/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_NP_TOOLKIT_PARAMETERS_H_
#define _SCE_NP_TOOLKIT_PARAMETERS_H_

#include "ids.h"
#include <ostream>

namespace sce { 
	namespace Toolkit {
		namespace NP {

	/// @brief
	/// The type of function that should be passed as an event callback to the Interface.
	///
	/// The type of function that should be passed as a callback to the Interface for the return of
	/// event codes. These events can then be acted on by application code as and when needed. See the particular Event or
	/// service you require for further definition.
	///
	/// @param event The Event the callback function has been called for.
	typedef void (*NpToolkitCallback)(const Event& event);

	/// @brief
	/// The type of function that should be passed as an event callback to the Interface.
	///
	/// The type of function that should be passed as a callback to the Interface for the return of
	/// event codes. These events can then be acted on by application code as and when needed. See the particular Event or
	/// service you require for further definition.
	///
	/// @param event The Event the callback function has been called for.
	/// @param appData A pointer to the application data which is returned when the event callback is called.
	typedef void (*NpToolkitCallback2)(const Event& event, void *appData);

	/// @brief
	/// Contains the parameters for initializing the %NP %Toolkit library.
	///
	/// Contains the parameters for initializing the %NP %Toolkit library. These are all initialized to a default value
	/// when the constructor is called. The class members are all public so these starting values can easily
	/// be updated before the call to Interface::init().
	class Parameters
	{
	public:
		/// @brief
		/// A constructor for the Parameters class.
		///
		/// A constructor for the Parameters class.
		///
		/// Default values:
		///		
		///
		///	<c>m_out</c> = <c>std::cout</c>
		///
		///	<c>m_err</c> = <c>std::cerr</c>
		///
		///	<c>m_ageRating</c> = 0 - indicates a universal game
		///
		///	<c>m_trial</c> = false - not a trial mode game
		///
		///	<c>m_id</c> = An empty CommunicationId. This will not work for games needing certain services.
		///
		/// @param mCallback	The NpToolkitCallback to be registered for events.
		/// @param _id			The main %NP Communication ID assumed to be used for all services.
		Parameters(NpToolkitCallback mCallback, CommunicationId& _id) :
			m_out(std::cout),
			m_err(std::cerr),
			m_ageRating(0),
			m_trial(false),
			m_id(_id),
			m_callbackFunc(mCallback),
			m_callbackFunc2(0),
			m_appData(0)
		{}

		/// @brief
		/// A constructor for the Parameters class.
		///
		/// A constructor for the Parameters class.
		///
		/// Default values:
		///		
		///
		///	<c>m_out</c> = <c>std::cout</c>
		///
		///	<c>m_err</c> = <c>std::cerr</c>
		///
		///	<c>m_ageRating</c> = 0 - indicates a universal game
		///
		///	<c>m_trial</c> = false - not a trial mode game
		///
		///	<c>m_id</c> = An empty CommunicationId. This will not work for games needing certain services.
		///
		/// @param mCallback	The NpToolkitCallback2 to be registered for events.
		/// @param _id			The main %NP Communication ID assumed to be used for all services.
		/// @param appData		A pointer to the application data which is returned when the NpToolkitCallback2 callback is called.	
		Parameters(NpToolkitCallback2 mCallback, CommunicationId& _id, void *appData) :
			m_out(std::cout),
			m_err(std::cerr),
			m_ageRating(0),
			m_trial(false),
			m_id(_id),
			m_callbackFunc(0),
			m_callbackFunc2(mCallback),
			m_appData(appData)
		{}

		std::ostream&	m_out;						///< An output stream for debug information.
		std::ostream&	m_err;						///< An output stream for error information.
		unsigned short	m_ageRating;				///< The age rating of the title in years old.
		bool			m_trial;					///< A flag that specifies whether the application is in trial mode or not.
		CommunicationId m_id;						///< The %NP Communication ID of this application.
		ServiceId		m_commerceServiceId;		///< The Service ID used for commerce.
		ServiceId		m_ticketingServiceId;		///< The Service ID used for ticketing.
		NpToolkitCallback m_callbackFunc;			///< A pointer to a callback used for returning events to the application.
		NpToolkitCallback2 m_callbackFunc2;			///< A pointer to a callback used for returning events to the application. This callback allows for application data to be returned via the callback.
		void *m_appData;							///< A pointer to the application data which is returned when <c><i>m_callbackFunc2</i></c> is called.
	};

		}//end NP
	}//end Toolkit
}//end Sce
#endif
